///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CGETPKS_CPP
#define _CGETPKS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../../SharedSource/Debug.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "../SQLClass/cSQL.H"
#include "../SQLClass/cRecordSet.H"

#include "CGetPKs.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CGetPKs::Get(CSQL *pcSQL, char *sDB, char *sDBO, char *sTable)
{
	int iTempSz = 0;

	char *sSQL = NULL;
	char sPKCol[1024];
	char *sBaseSQL = NULL;

	bool bGetPKName = true;
	bool bRetVal = false;

	CRecordSet rsTemp;

	iPKs = 0;

	sBaseSQL =
		"SELECT"
		" [Objects].[Name] AS [ConstraintName],"
		" [Columns].[Name] AS [KeyColumn],"
		" [Types].[Name] AS [KeyColumnType],"
		" [Columns].[Length] AS [KeyColumnLength],"
		" (CASE WHEN [Types].[Name] IN ('Binary', 'Char', 'nChar', 'nVarChar', 'VarBinary', 'VarChar') THEN 1 ELSE 0 END) AS [TypeStatus]"
		" FROM [%s].[%s].[SysObjects] AS [Objects]"
		" INNER JOIN [%s].[%s].[SysColumns] AS [Columns] ON [Objects].Parent_Obj = [Columns].ID"
		" INNER JOIN [%s].[%s].[SysTypes] AS [Types] ON [Types].[xType] = [Columns].[xType]"
		" INNER JOIN [%s].[%s].[SysIndexKeys] AS [IndexKeys] ON [IndexKeys].ColId = [Columns].ColId"
		" INNER JOIN [%s].[%s].[SysIndexes] AS [Indexes] ON [Objects].Name = [Indexes].Name"
			" AND [Indexes].IndId = [IndexKeys].IndId"
			" AND [Indexes].ID = [IndexKeys].ID"
		" WHERE [Objects].[xType] = 'PK' AND [Objects].[Parent_Obj] = Object_Id('[%s].[%s].[%s]')"
		" ORDER BY [IndexKeys].[KeyNo]";

	iTempSz = (strlen(sBaseSQL) + (strlen(sDB) * 6) + (strlen(sDBO) * 6) + strlen(sTable)) + 1;
	
	sSQL = (char *) gMem.Allocate(iTempSz + 1, sizeof(char));

	sprintf_s(sSQL, iTempSz, sBaseSQL,
		sDB, sDBO, sDB, sDBO, sDB, sDBO,
		sDB, sDBO, sDB, sDBO, sDB, sDBO, sTable);

	bRetVal = pcSQL->Execute(sSQL, &rsTemp);

	gMem.Free(sSQL);

	if(!bRetVal)
	{
		rsTemp.Close();
		return false;
	}

	strcpy_s(sPKTable, sizeof(sPKTable), sTable);
    strcpy_s(sPKDBO, sizeof(sPKDBO), sDBO);
    strcpy_s(sPKDB, sizeof(sPKDB), sDB);

	if(rsTemp.RowCount > 0)
	{
		sPKs = (char **) gMem.Allocate(sizeof(char *), rsTemp.RowCount + 1);
		Assert(!sPKs, "Memory Allocation Error.");
		sPKType = (char **) gMem.Allocate(sizeof(char *), rsTemp.RowCount + 1);
		Assert(!sPKType, "Memory Allocation Error.");
		iPKLen = (int *) gMem.Allocate(sizeof(int), rsTemp.RowCount + 1);
		Assert(!iPKLen, "Memory Allocation Error.");
		iPKStatus = (int *) gMem.Allocate(sizeof(int), rsTemp.RowCount + 1);
		Assert(!iPKStatus, "Memory Allocation Error.");

		bAlloc = true;

		while(rsTemp.Fetch())
		{
			iTempSz = 0;

			if(bGetPKName)
			{
				//Constraint Name.
				rsTemp.sColumnEx(1, sPKName, sizeof(sPKName), &iTempSz);
				bGetPKName = false;
			}

			//Key Column.
			rsTemp.sColumnEx(2, sPKCol, sizeof(sPKCol), &iTempSz);
			sPKs[iPKs] = (char *) gMem.Allocate(sizeof(char), iTempSz + 1);
			Assert(!sPKs[iPKs], "Memory Allocation Error.");
			strcpy_s(sPKs[iPKs], iTempSz + 1, sPKCol);

			//Key Column Type.
			rsTemp.sColumnEx(3, sPKCol, sizeof(sPKCol), &iTempSz);
			sPKType[iPKs] = (char *) gMem.Allocate(sizeof(char), iTempSz + 1);
			Assert(!sPKType[iPKs], "Memory Allocation Error.");
			strcpy_s(sPKType[iPKs], iTempSz + 1, sPKCol);

			//Key Column Length.
			iPKLen[iPKs] = rsTemp.lColumn(4);

			//Type Status.
			iPKStatus[iPKs] = rsTemp.lColumn(5);

			iPKs++;
		}
		bRetVal = true;
	}
	else{
		bRetVal = false;
	}

	rsTemp.Close();

	return bRetVal;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CGetPKs::Free(void)
{
	if(bAlloc)
	{
		int iKey = 0;

		if(iKey < iPKs)
		{
			while(iKey < iPKs)
			{
				gMem.Free(sPKs[iKey]);
				gMem.Free(sPKType[iKey]);
				iKey++;
			}
		}

		gMem.Free(sPKs);
		gMem.Free(sPKType);
		gMem.Free(iPKLen);
		gMem.Free(iPKStatus);

		bAlloc = false;
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CGetPKs::CGetPKs()
{
	bAlloc = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CGetPKs::~CGetPKs()
{
	Free();
	bAlloc = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
